(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      3106,        112]*)
(*NotebookOutlinePosition[      3923,        140]*)
(*  CellTagsIndexPosition[      3879,        136]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(\(**MASS\)\ DRIVER\ FINAL\ \(VELOCITY**\)\)], "Input"],

Cell[BoxData[
    \(18000\  - \ mass\ driver\ acceleration\ \((m/s)\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[\@\(2 \((18000*40500)\)\)\/18000]\)], "Input"],

Cell[BoxData[
    \(2.12132034355964238`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(2.12132034355964238` - \ 
      time\ for\ payload\ to\ travel\ total\ mass\ driver\ length\ 
        \((40.5\ km)\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(2.12132034355964238`*18000\)], "Input"],

Cell[BoxData[
    \(38183.766184073562`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(38183.766184073562`\  - \ payload' s\ final\ velocity\ \((m/s)\)\)], 
  "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(38183.766184073562`/1000\)], "Input"],

Cell[BoxData[
    \(38.183766184073562`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(38.183766184073562`\  - \ payload' s\ final\ velocity\ \((km/s)\)\)], 
  "Input"],

Cell[BoxData[
    \(\(**\[CapitalDelta]V\)\ AVAILIBLE\ FROM\ MASS\ \(DRIVERS**\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(38.183766184073562`*Log[\(5*10^15\)\/1.20590907422226578`*^15]\)], 
  "Input"],

Cell[BoxData[
    \(54.305113077169107`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(54.305113077169107`\  - \ 
      total\ \[CapitalDelta]V\ availible\ from\ mass\ drivers\)], "Input"]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 640}, {0, 424}},
ScreenStyleEnvironment->"Working",
PrintingStyleEnvironment->"Printout",
WindowSize->{464, 432},
WindowMargins->{{0, Automatic}, {Automatic, 5}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
StyleDefinitions -> "Default.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 74, 1, 22, "Input"],
Cell[1786, 52, 82, 1, 22, "Input"],

Cell[CellGroupData[{
Cell[1893, 57, 68, 1, 35, "Input"],
Cell[1964, 60, 54, 1, 22, "Output"]
}, Open  ]],
Cell[2033, 64, 149, 3, 22, "Input"],

Cell[CellGroupData[{
Cell[2207, 71, 59, 1, 22, "Input"],
Cell[2269, 74, 53, 1, 22, "Output"]
}, Open  ]],
Cell[2337, 78, 100, 2, 30, "Input"],

Cell[CellGroupData[{
Cell[2462, 84, 57, 1, 30, "Input"],
Cell[2522, 87, 53, 1, 29, "Output"]
}, Open  ]],
Cell[2590, 91, 101, 2, 30, "Input"],
Cell[2694, 95, 93, 1, 30, "Input"],

Cell[CellGroupData[{
Cell[2812, 100, 98, 2, 42, "Input"],
Cell[2913, 104, 53, 1, 29, "Output"]
}, Open  ]],
Cell[2981, 108, 121, 2, 30, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

